﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
		moveTimeout
			addTimeout( ID )
			remove( ID )
			exists( ID )
			removeAll()
*/
#include "functions/once.as"
// run()
define_moveWait = function( thisCommand_obj ){
	
	
	var prom = VOW.make();
	var nextEvent = once( prom.keep );		// calling nextEvent() calls prom.keep()
	
	
	if(TRACE_SCRIPT)
		trace("moveWait");
	
	var waitMode = thisCommand_obj.data.mode;
	if( !waitMode )		waitMode = "time";
	
	
	
	if( waitMode === "time" ){
		// wait a moment,  then run next command
		var waitTime = thisCommand_obj.data.value*1000;		// convert seconds to milliseconds
		thisCommand_obj.timeout = setTimeout( function(){
			thisCommand_obj.moveTimeout.remove();		// remove timeout from storage
			nextEvent();
		}, waitTime );
		thisCommand_obj.moveTimeout.addTimeout( thisCommand_obj.timeout );		// store wait timeout
	}// wait for "time"
	
	
	
	if(waitMode=="animation")
	{
		var waitForAnimDone = function(){
			var reaction = {};
			spriteImage.addListener( reaction );
			reaction.unload = reaction.animDone = function(){
				spriteImage.removeListener( reaction );
				if( _this._name !== undefined)		nextEvent();
			}// animDone / unload()
		}// waitForAnimDone()
		
		// use the outer "move" command's sprite reference
		var spriteImage = thisCommand_obj.sprite.image;
		
		// if:  not already on the last frame
		var frame = spriteImage.getParam("frame");
		var frames = spriteImage.getParam("frames");
		if(frame<frames  &&  spriteImage.getParam("isAnimating") )
			waitForAnimDone();
		else
			nextEvent();
	}// if:  animation
	
	
	// wait for promise
	return prom;
	
	
}// define_moveWait()